#!/usr/bin/env bash
set -euo pipefail

# build-container.sh [target]
# target: 68k | ppc-amigaos | ppc-morphos | all (default: all)

TARGET=${1:-all}
ROOT_DIR="$(cd "$(dirname "$0")" && pwd)"

echo "Checking Docker availability..."
COUNT=0
until docker info >/dev/null 2>&1; do
  COUNT=$((COUNT+1))
  if [ $COUNT -ge 60 ]; then
    echo "Docker did not become available after 120 seconds."
    exit 1
  fi
  sleep 2
done
echo "Docker is available."

build_or_pull() {
  local tgt=$1
  local folder="$ROOT_DIR/.devcontainer/$2"
  local image=$3
  if [ "$TARGET" != "all" ] && [ "$TARGET" != "$tgt" ]; then
    return
  fi
  if [ -f "$folder/Dockerfile" ]; then
    echo "Building image $image from $folder"
    docker build -t "$image" "$folder"
  else
    echo "No Dockerfile in $folder; pulling $image"
    docker pull "$image"
  fi
}

build_or_pull 68k "amiga-68k" "sacredbanana/amiga-compiler:m68k-amigaos"
build_or_pull ppc-amigaos "amigaos-ppc" "sacredbanana/amiga-compiler:ppc-amigaos"
build_or_pull ppc-morphos "morphos-ppc" "sacredbanana/amiga-compiler:ppc-morphos"

echo "All requested targets processed."
